/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gems.GemsBase;
import net.silentchaos512.gems.setup.GemsBlocks;
import net.silentchaos512.gems.util.Gems;
import org.apache.commons.compress.utils.Lists;

public class GemsWorldGen {
    public static final RuleTest BASE_STONE_END = new TagMatchTest(Tags.Blocks.END_STONES);

    public static void init(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        RegistryOps ops = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)RegistryAccess.m_206197_());
        LinkedHashMap configuredFeatures = Maps.newLinkedHashMap();
        LinkedHashMap placedFeatures = Maps.newLinkedHashMap();
        ArrayList overworldFeatureList = Lists.newArrayList();
        ArrayList netherFeatureList = Lists.newArrayList();
        ArrayList endFeatureList = Lists.newArrayList();
        HolderSet.Named overworldBiomes = new HolderSet.Named((Registry)ops.m_206826_(Registry.f_122885_).get(), BiomeTags.f_215817_);
        HolderSet.Named netherBiomes = new HolderSet.Named((Registry)ops.m_206826_(Registry.f_122885_).get(), BiomeTags.f_207612_);
        HolderSet.Named endBiomes = new HolderSet.Named((Registry)ops.m_206826_(Registry.f_122885_).get(), BiomeTags.f_215818_);
        ResourceLocation silverName = GemsBase.getId("silver_ore");
        ImmutableList silverTargetBlocks = ImmutableList.of((Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((Block)GemsBlocks.SILVER_ORE.get()).m_49966_()), (Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)((Block)GemsBlocks.DEEPSLATE_SILVER_ORE.get()).m_49966_()));
        ConfiguredFeature silverOreFeature = new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration((List)silverTargetBlocks, 7));
        PlacedFeature silverOrePlaced = new PlacedFeature(GemsWorldGen.holder(silverOreFeature, (RegistryOps<JsonElement>)ops, silverName), List.of(CountPlacement.m_191628_((int)2), RarityFilter.m_191900_((int)1), HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)36)), InSquarePlacement.m_191715_(), BiomeFilter.m_191561_()));
        configuredFeatures.put(silverName, silverOreFeature);
        placedFeatures.put(silverName, silverOrePlaced);
        overworldFeatureList.add(GemsWorldGen.holderPlaced(silverOrePlaced, (RegistryOps<JsonElement>)ops, silverName));
        for (Gems gem : Gems.values()) {
            ResourceLocation overworldOreName = GemsBase.getId(gem.getName() + "_overworld_ore");
            ResourceLocation netherOreName = GemsBase.getId(gem.getName() + "_nether_ore");
            ResourceLocation endOreName = GemsBase.getId(gem.getName() + "_end_ore");
            ConfiguredFeature<OreConfiguration, ?> oreOverworld = gem.createOreConfiguredFeature((ResourceKey<Level>)Level.f_46428_);
            ConfiguredFeature<OreConfiguration, ?> oreNether = gem.createOreConfiguredFeature((ResourceKey<Level>)Level.f_46429_);
            ConfiguredFeature<OreConfiguration, ?> oreEnd = gem.createOreConfiguredFeature((ResourceKey<Level>)Level.f_46430_);
            PlacedFeature placedOreOverworld = gem.createOrePlacedFeature((ResourceKey<Level>)Level.f_46428_, GemsWorldGen.holder(oreOverworld, (RegistryOps<JsonElement>)ops, overworldOreName));
            PlacedFeature placedOreNether = gem.createOrePlacedFeature((ResourceKey<Level>)Level.f_46429_, GemsWorldGen.holder(oreNether, (RegistryOps<JsonElement>)ops, netherOreName));
            PlacedFeature placedOreEnd = gem.createOrePlacedFeature((ResourceKey<Level>)Level.f_46430_, GemsWorldGen.holder(oreEnd, (RegistryOps<JsonElement>)ops, endOreName));
            configuredFeatures.put(overworldOreName, oreOverworld);
            configuredFeatures.put(netherOreName, oreNether);
            configuredFeatures.put(endOreName, oreEnd);
            placedFeatures.put(overworldOreName, placedOreOverworld);
            placedFeatures.put(netherOreName, placedOreNether);
            placedFeatures.put(endOreName, placedOreEnd);
            overworldFeatureList.add(GemsWorldGen.holderPlaced(placedOreOverworld, (RegistryOps<JsonElement>)ops, overworldOreName));
            netherFeatureList.add(GemsWorldGen.holderPlaced(placedOreNether, (RegistryOps<JsonElement>)ops, netherOreName));
            endFeatureList.add(GemsWorldGen.holderPlaced(placedOreEnd, (RegistryOps<JsonElement>)ops, endOreName));
            ResourceLocation overworldGlowroseName = GemsBase.getId(gem.getName() + "_overworld_glowrose");
            ResourceLocation netherGlowroseName = GemsBase.getId(gem.getName() + "_nether_glowrose");
            ResourceLocation endGlowroseName = GemsBase.getId(gem.getName() + "_end_glowrose");
            ConfiguredFeature<RandomPatchConfiguration, ?> glowroseOverworld = gem.createGlowroseConfiguredFeature((ResourceKey<Level>)Level.f_46428_);
            ConfiguredFeature<RandomPatchConfiguration, ?> glowroseNether = gem.createGlowroseConfiguredFeature((ResourceKey<Level>)Level.f_46429_);
            ConfiguredFeature<RandomPatchConfiguration, ?> glowroseEnd = gem.createGlowroseConfiguredFeature((ResourceKey<Level>)Level.f_46430_);
            PlacedFeature placedGlowroseOverworld = gem.createGlowrosePlacedFeature((ResourceKey<Level>)Level.f_46428_, GemsWorldGen.holder(glowroseOverworld, (RegistryOps<JsonElement>)ops, overworldGlowroseName));
            PlacedFeature placedGlowroseNether = gem.createGlowrosePlacedFeature((ResourceKey<Level>)Level.f_46429_, GemsWorldGen.holder(glowroseNether, (RegistryOps<JsonElement>)ops, netherGlowroseName));
            PlacedFeature placedGlowroseEnd = gem.createGlowrosePlacedFeature((ResourceKey<Level>)Level.f_46430_, GemsWorldGen.holder(glowroseEnd, (RegistryOps<JsonElement>)ops, endGlowroseName));
            configuredFeatures.put(overworldGlowroseName, glowroseOverworld);
            configuredFeatures.put(netherGlowroseName, glowroseNether);
            configuredFeatures.put(endGlowroseName, glowroseEnd);
            placedFeatures.put(overworldGlowroseName, placedGlowroseOverworld);
            placedFeatures.put(netherGlowroseName, placedGlowroseNether);
            placedFeatures.put(endGlowroseName, placedGlowroseEnd);
            overworldFeatureList.add(GemsWorldGen.holderPlaced(placedGlowroseOverworld, (RegistryOps<JsonElement>)ops, overworldGlowroseName));
            netherFeatureList.add(GemsWorldGen.holderPlaced(placedGlowroseNether, (RegistryOps<JsonElement>)ops, netherGlowroseName));
            endFeatureList.add(GemsWorldGen.holderPlaced(placedGlowroseEnd, (RegistryOps<JsonElement>)ops, endGlowroseName));
        }
        ForgeBiomeModifiers.AddFeaturesBiomeModifier overworldOres = new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)overworldBiomes, (HolderSet)HolderSet.m_205800_((List)overworldFeatureList), GenerationStep.Decoration.UNDERGROUND_ORES);
        ForgeBiomeModifiers.AddFeaturesBiomeModifier netherOres = new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)netherBiomes, (HolderSet)HolderSet.m_205800_((List)netherFeatureList), GenerationStep.Decoration.UNDERGROUND_ORES);
        ForgeBiomeModifiers.AddFeaturesBiomeModifier endOres = new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)endBiomes, (HolderSet)HolderSet.m_205800_((List)endFeatureList), GenerationStep.Decoration.UNDERGROUND_ORES);
        JsonCodecProvider configuredFeatureProvider = JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"silentgems", (RegistryOps)ops, (ResourceKey)Registry.f_122881_, (Map)configuredFeatures);
        JsonCodecProvider placedFeatureProvider = JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"silentgems", (RegistryOps)ops, (ResourceKey)Registry.f_194567_, (Map)placedFeatures);
        JsonCodecProvider biomeModifierProvider = JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"silentgems", (RegistryOps)ops, (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (Map)ImmutableMap.of((Object)GemsBase.getId("overworld_ores"), (Object)overworldOres, (Object)GemsBase.getId("nether_ores"), (Object)netherOres, (Object)GemsBase.getId("end_ores"), (Object)endOres));
        generator.m_236039_(true, (DataProvider)configuredFeatureProvider);
        generator.m_236039_(true, (DataProvider)placedFeatureProvider);
        generator.m_236039_(true, (DataProvider)biomeModifierProvider);
    }

    public static Holder<ConfiguredFeature<?, ?>> holder(ConfiguredFeature<?, ?> feature, RegistryOps<JsonElement> ops, ResourceLocation location) {
        return ops.f_206806_.m_175515_(Registry.f_122881_).m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_122881_, (ResourceLocation)location));
    }

    public static Holder<PlacedFeature> holderPlaced(PlacedFeature feature, RegistryOps<JsonElement> ops, ResourceLocation location) {
        return ops.f_206806_.m_175515_(Registry.f_194567_).m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)location));
    }
}

