/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.registries.RegistryObject;
import net.silentchaos512.gems.block.GemLampBlock;
import net.silentchaos512.gems.setup.GemsBlocks;
import net.silentchaos512.gems.setup.GemsItems;
import net.silentchaos512.gems.setup.Registration;
import net.silentchaos512.gems.util.Gems;

public class GemsLootTableProvider
extends LootTableProvider {
    public GemsLootTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(BlockLootTables::new, (Object)LootContextParamSets.f_81421_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
        map.forEach((p_218436_2_, p_218436_3_) -> LootTables.m_79202_((ValidationContext)validationtracker, (ResourceLocation)p_218436_2_, (LootTable)p_218436_3_));
    }

    private static final class BlockLootTables
    extends BlockLoot {
        private BlockLootTables() {
        }

        protected void addTables() {
            for (Gems gem : Gems.values()) {
                this.registerFortuneDrops((Block)gem.getOre(), gem.getItem());
                this.registerFortuneDrops((Block)gem.getDeepslateOre(), gem.getItem());
                this.registerFortuneDrops((Block)gem.getNetherOre(), gem.getItem());
                this.registerFortuneDrops((Block)gem.getEndOre(), gem.getItem());
                this.m_124288_(gem.getBlock());
                this.m_124288_(gem.getBricks());
                this.m_124288_((Block)gem.getGlass());
                for (GemLampBlock.State state : GemLampBlock.State.values()) {
                    this.m_124147_(gem.getLamp(state), (ItemLike)gem.getLamp(state.withPower(false)));
                }
                this.m_124288_((Block)gem.getGlowrose());
                this.m_124252_((Block)gem.getPottedGlowrose());
            }
            this.registerFortuneDrops((Block)GemsBlocks.SILVER_ORE.get(), (Item)GemsItems.RAW_SILVER.get());
            this.registerFortuneDrops((Block)GemsBlocks.DEEPSLATE_SILVER_ORE.get(), (Item)GemsItems.RAW_SILVER.get());
            this.m_124288_((Block)GemsBlocks.SILVER_BLOCK.get());
        }

        protected Iterable<Block> getKnownBlocks() {
            return Registration.BLOCKS.getEntries().stream().map(RegistryObject::get).collect(Collectors.toList());
        }

        private void registerFortuneDrops(Block block, Item item) {
            this.m_124165_(block, BlockLootTables.m_124139_((Block)block, (Item)item));
        }
    }
}

