/*
 * Decompiled with CFR 0.152.
 */
package com.exidex.swingthroughgrass;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public final class LeftClickEventHandler {
    public static final List<Predicate<LivingEntity>> PREDICATES = Lists.newArrayList();

    private LeftClickEventHandler() {
    }

    @SubscribeEvent
    public static void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        BlockState state = event.getLevel().m_8055_(event.getPos());
        if (!state.m_60812_((BlockGetter)event.getLevel(), event.getPos()).m_83281_()) {
            return;
        }
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        EntityHitResult rayTraceResult = LeftClickEventHandler.rayTraceEntity(player, 1.0f, 4.5);
        if (rayTraceResult != null && !event.getLevel().f_46443_) {
            player.m_5706_(rayTraceResult.m_82443_());
            player.m_36334_();
        }
    }

    @Nullable
    private static EntityHitResult rayTraceEntity(Player player, float partialTicks, double blockReachDistance) {
        Vec3 from = player.m_20299_(partialTicks);
        Vec3 look = player.m_20252_(partialTicks);
        Vec3 to = from.m_82520_(look.f_82479_ * blockReachDistance, look.f_82480_ * blockReachDistance, look.f_82481_ * blockReachDistance);
        return ProjectileUtil.m_37304_((Level)player.f_19853_, (Entity)player, (Vec3)from, (Vec3)to, (AABB)new AABB(from, to), EntitySelector.f_20406_.and(e -> e != null && e.m_6087_() && e instanceof LivingEntity && !(e instanceof FakePlayer) && !LeftClickEventHandler.getAllRidingEntities(player).contains(e) && PREDICATES.stream().allMatch(predicate -> predicate.test((LivingEntity)e))));
    }

    private static List<Entity> getAllRidingEntities(Player player) {
        ArrayList<Entity> ridingEntities = new ArrayList<Entity>();
        Player entity = player;
        while (entity.m_20159_()) {
            entity = entity.m_20202_();
            ridingEntities.add((Entity)entity);
        }
        return ridingEntities;
    }
}

