/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.world.gen.features;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Fluids;
import net.orcinus.galosphere.blocks.PollinatedClusterBlock;
import net.orcinus.galosphere.world.gen.features.config.CrystalSpikeConfig;

public class CrystalSpikeFeature
extends Feature<CrystalSpikeConfig> {
    public CrystalSpikeFeature(Codec<CrystalSpikeConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<CrystalSpikeConfig> context) {
        WorldGenLevel world = context.m_159774_();
        BlockPos blockPos = context.m_159777_();
        RandomSource random = context.m_225041_();
        CrystalSpikeConfig config = (CrystalSpikeConfig)context.m_159778_();
        HashSet trigList = Sets.newHashSet();
        HashSet clusterPos = Sets.newHashSet();
        boolean flag = false;
        int radiusCheck = config.xzRadius.m_214085_(random) + 1;
        int randomChance = random.m_188503_(4);
        int stepHeight = radiusCheck + 14 + Mth.m_216271_((RandomSource)random, (int)10, (int)14);
        if (world.m_7433_(blockPos.m_121945_(config.crystal_direction.m_162107_().m_122424_()), DripstoneUtils::m_159666_) && world.m_8055_(blockPos).m_204336_(BlockTags.f_13061_) && this.placeSpike((LevelAccessor)world, blockPos, radiusCheck, stepHeight, randomChance, trigList, config.crystal_direction.m_162107_(), random)) {
            flag = this.placeCrystals(world, random, config, trigList, clusterPos, flag);
        }
        return flag;
    }

    private boolean placeCrystals(WorldGenLevel world, RandomSource random, CrystalSpikeConfig config, HashSet<BlockPos> trigList, HashSet<BlockPos> clusterPos, boolean flag) {
        for (BlockPos pos : trigList) {
            if (!world.m_7433_(pos, DripstoneUtils::m_159666_)) continue;
            this.m_5974_((LevelWriter)world, pos, config.crystal_state);
            clusterPos.add(pos);
            flag = true;
        }
        for (BlockPos pos : clusterPos) {
            if (random.m_188503_(6) != 0) continue;
            for (Direction direction : Direction.values()) {
                BlockPos relative = pos.m_121945_(direction);
                if (!random.m_188499_() || !world.m_7433_(relative, DripstoneUtils::m_159664_) || !world.m_8055_(pos).equals(config.crystal_state)) continue;
                this.m_5974_((LevelWriter)world, relative, (BlockState)((BlockState)((BlockState)config.cluster_state.m_61124_((Property)PollinatedClusterBlock.POLLINATED, (Comparable)Boolean.valueOf(random.m_188499_()))).m_61124_((Property)PollinatedClusterBlock.f_152006_, (Comparable)direction)).m_61124_((Property)PollinatedClusterBlock.f_152005_, (Comparable)Boolean.valueOf(world.m_6425_(relative).m_76152_() == Fluids.f_76193_)));
            }
        }
        return flag;
    }

    public boolean placeSpike(LevelAccessor world, BlockPos blockPos, int startRadius, int height, int randomChance, HashSet<BlockPos> crystalPos, Direction direction, RandomSource random) {
        boolean flag = false;
        if (startRadius < 1) {
            return false;
        }
        for (int y = 0; y < height; ++y) {
            int radius = startRadius - y / 2;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos = new BlockPos(blockPos.m_123341_() + x, blockPos.m_123342_(), blockPos.m_123343_() + z);
                    if (x * x + z * z > radius * radius) continue;
                    if (direction == Direction.DOWN) {
                        if (world.m_7433_(pos.m_7495_(), DripstoneUtils::m_159666_)) {
                            return this.placeSpike(world, blockPos.m_7495_(), startRadius / 2, height, randomChance, crystalPos, direction, random);
                        }
                    } else if (direction == Direction.UP) {
                        BlockPos.MutableBlockPos mut = pos.m_122032_();
                        for (int i = 0; i < 10 && world.m_7433_(mut.m_7494_(), DripstoneUtils::m_159666_); ++i) {
                            mut.m_122173_(Direction.UP);
                        }
                        pos = mut.m_7949_();
                        if (world.m_7433_(pos.m_7494_(), DripstoneUtils::m_159666_)) {
                            return false;
                        }
                    }
                    this.calciteBloom(world, pos.m_121945_(direction), random, radius);
                    float delta = switch (randomChance) {
                        case 1 -> 5.759587f;
                        case 2 -> 0.5235988f;
                        case 3 -> 3.6651917f;
                        case 0 -> 2.617994f;
                        default -> throw new IllegalStateException("Unexpected value: " + randomChance);
                    };
                    float q = Mth.m_14089_((float)delta) * (float)y;
                    float k = Mth.m_14031_((float)1.5707964f) * (float)y;
                    float l = Mth.m_14031_((float)delta) * (float)y;
                    float xx = direction == Direction.UP ? -q : q;
                    float yy = direction == Direction.UP ? -k : k;
                    float zz = direction == Direction.UP ? -l : l;
                    BlockPos trigPos = pos.m_7637_((double)xx, (double)yy, (double)zz);
                    if (world.m_7433_(trigPos, DripstoneUtils::m_159666_)) {
                        crystalPos.add(trigPos);
                        flag = true;
                        continue;
                    }
                    crystalPos.remove(trigPos);
                }
            }
        }
        return flag;
    }

    private boolean calciteBloom(LevelAccessor world, BlockPos blockPos, RandomSource random, int crystalRadius) {
        int radius = crystalRadius / 4;
        int height = ConstantInt.m_146483_((int)2).m_214085_(random);
        boolean flag = false;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -height; y <= height; ++y) {
                    BlockPos pos = new BlockPos(blockPos.m_123341_() + x, blockPos.m_123342_() + y, blockPos.m_123343_() + z);
                    for (Direction direction : Direction.values()) {
                        if (!world.m_8055_(pos).m_204336_(BlockTags.f_13061_) || !world.m_7433_(pos.m_121945_(direction), DripstoneUtils::m_159666_)) continue;
                        world.m_7731_(pos, Blocks.f_152497_.m_49966_(), 2);
                        flag = true;
                    }
                }
            }
        }
        return flag;
    }
}

