/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.network;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.network.NetworkEvent;
import net.orcinus.galosphere.init.GSoundEvents;

public class SendParticlesPacket {
    private final BlockPos blockPos;

    public SendParticlesPacket(BlockPos blockPos) {
        this.blockPos = blockPos;
    }

    public static SendParticlesPacket read(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        return new SendParticlesPacket(pos);
    }

    public static void write(SendParticlesPacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.blockPos);
    }

    public static void handle(SendParticlesPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft minecraft = Minecraft.m_91087_();
            Optional.ofNullable(minecraft.f_91073_).ifPresent(world -> {
                RandomSource randomsource = world.m_213780_();
                world.m_104677_(packet.blockPos, (SoundEvent)GSoundEvents.GLOW_FLARE_SPREAD.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                boolean flag = world.m_8055_(packet.blockPos).m_60838_((BlockGetter)world, packet.blockPos);
                int l2 = flag ? 40 : 20;
                float f9 = flag ? 0.45f : 0.25f;
                for (int k3 = 0; k3 < l2; ++k3) {
                    float f12 = 2.0f * randomsource.m_188501_() - 1.0f;
                    float f14 = 2.0f * randomsource.m_188501_() - 1.0f;
                    float f15 = 2.0f * randomsource.m_188501_() - 1.0f;
                    world.m_7106_((ParticleOptions)ParticleTypes.f_175827_, (double)packet.blockPos.m_123341_() + 0.5 + (double)(f12 * f9), (double)packet.blockPos.m_123342_() + 0.5 + (double)(f14 * f9), (double)packet.blockPos.m_123343_() + 0.5 + (double)(f15 * f9), (double)(f12 * 0.07f), (double)(f14 * 0.07f), (double)(f15 * 0.07f));
                }
                world.m_104677_(packet.blockPos, (SoundEvent)GSoundEvents.GLOW_FLARE_SPREAD.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            });
        });
        ctx.get().setPacketHandled(true);
    }
}

