/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.events;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.orcinus.galosphere.api.BannerAttachable;
import net.orcinus.galosphere.api.GoldenBreath;
import net.orcinus.galosphere.api.SpectreBoundSpyglass;
import net.orcinus.galosphere.blocks.WarpedAnchorBlock;
import net.orcinus.galosphere.config.GalosphereConfig;
import net.orcinus.galosphere.entities.SparkleEntity;
import net.orcinus.galosphere.entities.SpectreEntity;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GCriteriaTriggers;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.items.SterlingArmorItem;
import net.orcinus.galosphere.util.BannerRendererUtil;

@Mod.EventBusSubscriber(modid="galosphere", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MobEvents {
    @SubscribeEvent
    public static void registerEntityAttribute(EntityAttributeCreationEvent event) {
        SpawnPlacements.m_21754_((EntityType)((EntityType)GEntityTypes.SPARKLE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SparkleEntity::checkSparkleSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)GEntityTypes.SPECTRE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        event.put((EntityType)GEntityTypes.SPARKLE.get(), SparkleEntity.createAttributes().m_22265_());
        event.put((EntityType)GEntityTypes.SPECTRE.get(), SpectreEntity.createAttributes().m_22265_());
    }

    @SubscribeEvent
    public void onBreakSpeedChanged(PlayerEvent.BreakSpeed event) {
        BlockState state = event.getState();
        if (state.m_60734_() == Blocks.f_152491_ && ((Boolean)GalosphereConfig.SLOWED_BUDDING_AMETHYST_MINING_SPEED.get()).booleanValue()) {
            event.setNewSpeed(2.0f);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        Horse horse;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Horse && !((BannerAttachable)(horse = (Horse)livingEntity)).getBanner().m_41619_() && horse.m_30722_().m_150930_((Item)GItems.STERLING_HORSE_ARMOR.get())) {
            ItemStack copy = ((BannerAttachable)horse).getBanner();
            horse.m_19983_(copy);
            ((BannerAttachable)horse).setBanner(ItemStack.f_41583_);
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        boolean flag = event.getSource().m_19372_();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            Horse horse;
            Item horseItem;
            if (!flag) continue;
            float reductionAmount = 0.0f;
            Item item = entity.m_6844_(slot).m_41720_();
            if (entity instanceof Horse && (horseItem = (horse = (Horse)entity).m_30722_().m_41720_()) == GItems.STERLING_HORSE_ARMOR.get()) {
                float damageReduction = 4.0f;
                reductionAmount = event.getAmount() - damageReduction;
            }
            if (item instanceof SterlingArmorItem) {
                SterlingArmorItem sterlingArmorItem = (SterlingArmorItem)item;
                float damageReduction = sterlingArmorItem.getExplosionResistance(slot);
                reductionAmount = event.getAmount() - damageReduction;
            }
            if (!(item instanceof SterlingArmorItem) && (!(entity instanceof Horse) || ((Horse)entity).m_30722_().m_41720_() != GItems.STERLING_HORSE_ARMOR.get())) continue;
            event.setAmount(reductionAmount);
        }
    }

    @SubscribeEvent
    public void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        Horse horse;
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        Entity target = event.getTarget();
        BannerRendererUtil util = new BannerRendererUtil();
        if (target instanceof Horse && (horse = (Horse)target).m_30722_().m_150930_((Item)GItems.STERLING_HORSE_ARMOR.get())) {
            if (((BannerAttachable)horse).getBanner().m_41619_()) {
                if ((util.isTapestryStack(stack) || stack.m_41720_() instanceof BannerItem) && !horse.f_19853_.m_5776_()) {
                    event.setCanceled(true);
                    ItemStack copy = stack.m_41777_();
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    copy.m_41764_(1);
                    horse.f_19853_.m_6269_(null, (Entity)horse, SoundEvents.f_11973_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    horse.m_146852_(GameEvent.f_223708_, (Entity)player);
                    ((BannerAttachable)horse).setBanner(copy);
                    player.m_6674_(hand);
                }
            } else if (player.m_6144_() && stack.m_41619_() && !horse.f_19853_.m_5776_()) {
                event.setCanceled(true);
                ItemStack copy = ((BannerAttachable)horse).getBanner();
                player.m_21008_(hand, copy);
                horse.f_19853_.m_6269_(null, (Entity)horse, SoundEvents.f_11973_, SoundSource.PLAYERS, 1.0f, 1.0f);
                horse.m_146852_(GameEvent.f_223708_, (Entity)player);
                ((BannerAttachable)horse).setBanner(ItemStack.f_41583_);
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        GoldenBreath goldenBreath;
        BannerAttachable bannerEntity;
        LivingEntity entity = event.getEntity();
        ItemStack useItem = entity.m_21211_();
        if (entity instanceof BannerAttachable && !(bannerEntity = (BannerAttachable)entity).getBanner().m_41619_()) {
            if (entity instanceof Horse) {
                Horse horse = (Horse)entity;
                if (!((BannerAttachable)horse).getBanner().m_41619_() && !horse.m_30722_().m_150930_((Item)GItems.STERLING_HORSE_ARMOR.get())) {
                    ItemStack copy = ((BannerAttachable)horse).getBanner();
                    horse.m_19983_(copy);
                    ((BannerAttachable)horse).setBanner(ItemStack.f_41583_);
                }
            } else if (!entity.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)GItems.STERLING_HELMET.get())) {
                ItemStack copy = bannerEntity.getBanner();
                entity.m_19983_(copy);
                bannerEntity.setBanner(ItemStack.f_41583_);
            }
        }
        if (entity.m_6084_() && entity instanceof GoldenBreath && (goldenBreath = (GoldenBreath)entity).getGoldenAirSupply() > 0.0f) {
            goldenBreath.setGoldenAirSupply(goldenBreath.decreaseGoldenAirSupply(entity, (int)goldenBreath.getGoldenAirSupply()));
        }
        if (SpectreBoundSpyglass.canUseSpectreBoundedSpyglass(useItem, entity) && useItem.m_41783_() != null && !entity.f_19853_.f_46443_) {
            Entity spectreBound = ((ServerLevel)entity.f_19853_).m_8791_(useItem.m_41783_().m_128342_("SpectreBoundUUID"));
            Optional.ofNullable(spectreBound).filter(SpectreEntity.class::isInstance).map(SpectreEntity.class::cast).filter(LivingEntity::m_6084_).ifPresent(spectre -> {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (spectre.getManipulatorUUID() != player.m_20148_()) {
                        boolean withinDistance;
                        boolean bl = withinDistance = Math.sqrt(Math.pow(player.m_20185_() - spectre.m_20185_(), 2.0) + Math.pow(player.m_20189_() - spectre.m_20189_(), 2.0)) < 110.0;
                        if (withinDistance) {
                            spectre.setCamera(player);
                        }
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void onTeleportEvent(EntityTeleportEvent.EnderPearl event) {
        block4: {
            ThrownEnderpearl pearl = event.getPearlEntity();
            ArrayList poses = Lists.newArrayList();
            ServerPlayer player = event.getPlayer();
            ServerLevel world = player.m_9236_();
            BlockPos pearlPos = pearl.m_20183_();
            int radius = 16;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    for (int y = -radius; y <= radius; ++y) {
                        BlockPos blockPos = new BlockPos(pearl.m_20185_() + (double)x, pearl.m_20186_() + (double)y, pearl.m_20189_() + (double)z);
                        BlockState blockState = world.m_8055_(blockPos);
                        if (!blockState.m_60713_((Block)GBlocks.WARPED_ANCHOR.get()) || (Integer)blockState.m_61143_((Property)WarpedAnchorBlock.WARPED_CHARGE) <= 0) continue;
                        poses.add(blockPos);
                    }
                }
            }
            if (poses.isEmpty()) break block4;
            poses.sort(Comparator.comparingDouble(arg_0 -> ((BlockPos)pearlPos).m_123331_(arg_0)));
            Iterator iterator = poses.iterator();
            if (iterator.hasNext()) {
                BlockPos blockPos = (BlockPos)iterator.next();
                event.setCanceled(true);
                GCriteriaTriggers.WARPED_TELEPORT.trigger(player);
                pearl.f_19853_.m_142346_((Entity)player, GameEvent.f_157792_, blockPos);
                pearl.f_19853_.m_5594_(null, blockPos, SoundEvents.f_12326_, SoundSource.BLOCKS, 1.0f, 1.0f);
                player.m_6021_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5);
                player.m_183634_();
                pearl.f_19853_.m_7731_(blockPos, (BlockState)pearl.f_19853_.m_8055_(blockPos).m_61124_((Property)WarpedAnchorBlock.WARPED_CHARGE, (Comparable)Integer.valueOf((Integer)pearl.f_19853_.m_8055_(blockPos).m_61143_((Property)WarpedAnchorBlock.WARPED_CHARGE) - 1)), 2);
                pearl.m_146870_();
            }
        }
    }
}

