/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.events;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.orcinus.galosphere.api.BannerAttachable;
import net.orcinus.galosphere.blocks.LumiereComposterBlock;
import net.orcinus.galosphere.compat.integration.terrablender.GalosphereRegion;
import net.orcinus.galosphere.config.GalosphereConfig;
import net.orcinus.galosphere.crafting.AuraRingerDispenseItemBehavior;
import net.orcinus.galosphere.crafting.GlowFlareDispenseItemBehavior;
import net.orcinus.galosphere.crafting.LumiereComposterDispenseItemBehavior;
import net.orcinus.galosphere.crafting.LumiereReformingManager;
import net.orcinus.galosphere.crafting.PickaxeDispenseItemBehavior;
import net.orcinus.galosphere.crafting.WarpedAnchorDispenseItemBehavior;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GSoundEvents;
import net.orcinus.galosphere.util.BannerRendererUtil;

@Mod.EventBusSubscriber(modid="galosphere", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MiscEvents {
    @SubscribeEvent
    public void onParallelDispatched(ParallelDispatchEvent event) {
        event.enqueueWork(() -> {
            block4: {
                try {
                    Class<?> aClass = Class.forName("terrablender.api.Region");
                    if (aClass == null) break block4;
                    try {
                        Class<?> clazz = Class.forName("orcinus.galosphere.compat.integration.terrablender.GalosphereRegion");
                        ((GalosphereRegion)((Object)((Object)clazz.getConstructor(new Class[0]).newInstance(new Object[0])))).init(event);
                    }
                    catch (ReflectiveOperationException e) {
                        throw new RuntimeException(e);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @SubscribeEvent
    public void onLoottableLoad(LootTableLoadEvent event) {
        ResourceLocation name = event.getName();
        LootTable table = event.getTable();
        if (name.equals((Object)new ResourceLocation("entities/pillager")) && ((Boolean)GalosphereConfig.PILLAGER_DROP_SILVER_INGOT.get()).booleanValue()) {
            table.addPool(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)GItems.SILVER_INGOT.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)))).m_79082_());
        }
    }

    @SubscribeEvent
    public void onResourceLoad(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new LumiereReformingManager());
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        BlockPos pos = event.getPos();
        Level world = event.getLevel();
        BlockState state = world.m_8055_(pos);
        if (player.m_6144_() && !((BannerAttachable)player).getBanner().m_41619_() && stack.m_41619_()) {
            ItemStack copy = ((BannerAttachable)player).getBanner();
            player.m_21008_(hand, copy);
            player.m_146852_(GameEvent.f_157811_, (Entity)player);
            ((BannerAttachable)player).setBanner(ItemStack.f_41583_);
        }
        if (state.m_60734_() == Blocks.f_50715_) {
            InteractionHand offHand = InteractionHand.OFF_HAND;
            if (stack.m_41720_() == GItems.LUMIERE_SHARD.get() && (Integer)state.m_61143_((Property)ComposterBlock.f_51913_) > 0 && (Integer)state.m_61143_((Property)ComposterBlock.f_51913_) < 8) {
                event.setCanceled(true);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                world.m_7731_(pos, (BlockState)((Block)GBlocks.LUMIERE_COMPOSTER.get()).m_49966_().m_61124_((Property)LumiereComposterBlock.f_51913_, (Comparable)((Integer)state.m_61143_((Property)ComposterBlock.f_51913_))), 2);
                world.m_5594_(null, pos, (SoundEvent)GSoundEvents.LUMIERE_COMPOST.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_142346_((Entity)player, GameEvent.f_157792_, pos);
                player.m_6674_(hand);
            }
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        Level world = event.getLevel();
        BannerRendererUtil util = new BannerRendererUtil();
        if (((BannerAttachable)player).getBanner().m_41619_() && player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)GItems.STERLING_HELMET.get()) && (util.isTapestryStack(stack) || stack.m_41720_() instanceof BannerItem)) {
            player.m_146852_(GameEvent.f_157811_, (Entity)player);
            ItemStack copy = stack.m_41777_();
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            copy.m_41764_(1);
            ((BannerAttachable)player).setBanner(copy);
            player.m_5496_(SoundEvents.f_11678_, 1.0f, 1.0f);
            player.m_6674_(hand);
        }
    }

    @SubscribeEvent
    public void onTagsUpdated(TagsUpdatedEvent event) {
        DispenserBlock.m_52672_((ItemLike)((Block)GBlocks.ALLURITE_BLOCK.get()).m_5456_(), (DispenseItemBehavior)new AuraRingerDispenseItemBehavior());
        DispenserBlock.m_52672_((ItemLike)((Block)GBlocks.ALLURITE_BLOCK.get()).m_5456_(), (DispenseItemBehavior)new WarpedAnchorDispenseItemBehavior());
        DispenserBlock.m_52672_((ItemLike)((ItemLike)GItems.LUMIERE_SHARD.get()), (DispenseItemBehavior)new LumiereComposterDispenseItemBehavior());
        DispenserBlock.m_52672_((ItemLike)((ItemLike)GItems.GLOW_FLARE.get()), (DispenseItemBehavior)new GlowFlareDispenseItemBehavior());
        Registry.f_122827_.m_206058_(ItemTags.f_144323_).iterator().forEachRemaining(holder -> DispenserBlock.m_52672_((ItemLike)((ItemLike)holder.m_203334_()), (DispenseItemBehavior)new PickaxeDispenseItemBehavior()));
    }
}

