/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.events;

import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.entity.HorseRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterEntitySpectatorShadersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.orcinus.galosphere.client.gui.CombustionTableScreen;
import net.orcinus.galosphere.client.gui.GoldenBreathOverlay;
import net.orcinus.galosphere.client.gui.IllusiveOverlay;
import net.orcinus.galosphere.client.gui.SpectreOverlay;
import net.orcinus.galosphere.client.model.SparkleModel;
import net.orcinus.galosphere.client.model.SpectreModel;
import net.orcinus.galosphere.client.model.SterlingArmorModel;
import net.orcinus.galosphere.client.particles.AuraParticle;
import net.orcinus.galosphere.client.particles.CrystalRainParticle;
import net.orcinus.galosphere.client.particles.providers.SilverBombProvider;
import net.orcinus.galosphere.client.particles.providers.WarpedProvider;
import net.orcinus.galosphere.client.renderer.GlowFlareEntityRenderer;
import net.orcinus.galosphere.client.renderer.SparkleRenderer;
import net.orcinus.galosphere.client.renderer.SpectreRenderer;
import net.orcinus.galosphere.client.renderer.layer.BannerLayer;
import net.orcinus.galosphere.client.renderer.layer.HorseBannerLayer;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GMenuTypes;
import net.orcinus.galosphere.init.GModelLayers;
import net.orcinus.galosphere.init.GParticleTypes;

@Mod.EventBusSubscriber(modid="galosphere", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        MenuScreens.m_96206_((MenuType)((MenuType)GMenuTypes.COMBUSTION_TABLE.get()), CombustionTableScreen::new);
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.register((Object)new IllusiveOverlay());
        eventBus.register((Object)new GoldenBreathOverlay());
        eventBus.register((Object)new SpectreOverlay());
        event.enqueueWork(() -> ItemProperties.register((Item)Items.f_42717_, (ResourceLocation)new ResourceLocation("galosphere", "glow_flare"), (stack, world, entity, p_174608_) -> entity != null && CrossbowItem.m_40932_((ItemStack)stack) && CrossbowItem.m_40871_((ItemStack)stack, (Item)((Item)GItems.GLOW_FLARE.get())) ? 1.0f : 0.0f));
    }

    @SubscribeEvent
    public static void loadEntityShader(RegisterEntitySpectatorShadersEvent event) {
        event.register((EntityType)GEntityTypes.SPECTRE.get(), new ResourceLocation("galosphere", "shaders/post/fay.json"));
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers event) {
        HorseRenderer horseRenderer = (HorseRenderer)event.getRenderer(EntityType.f_20457_);
        if (horseRenderer == null) {
            return;
        }
        horseRenderer.m_115326_((RenderLayer)new HorseBannerLayer((RenderLayerParent<Horse, HorseModel<Horse>>)horseRenderer));
        event.getSkins().forEach(skin -> {
            PlayerRenderer playerRenderer = (PlayerRenderer)event.getSkin(skin);
            if (playerRenderer == null) {
                return;
            }
            playerRenderer.m_115326_(new BannerLayer(playerRenderer));
        });
    }

    @SubscribeEvent
    public static void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(GModelLayers.SPARKLE, SparkleModel::createBodyLayer);
        event.registerLayerDefinition(GModelLayers.STERLING_HELMET, SterlingArmorModel::createBodyLayer);
        event.registerLayerDefinition(GModelLayers.SPECTRE, SpectreModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)GEntityTypes.SPARKLE.get(), SparkleRenderer::new);
        event.registerEntityRenderer((EntityType)GEntityTypes.SIVLER_BOMB.get(), context -> new ThrownItemRenderer(context, 1.5f, false));
        event.registerEntityRenderer((EntityType)GEntityTypes.SPECTRE.get(), SpectreRenderer::new);
        event.registerEntityRenderer((EntityType)GEntityTypes.GLOW_FLARE.get(), GlowFlareEntityRenderer::new);
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.register((ParticleType)GParticleTypes.AURA_LISTENER.get(), AuraParticle.Provider::new);
        event.register((ParticleType)GParticleTypes.SILVER_BOMB.get(), (ParticleProvider)new SilverBombProvider());
        event.register((ParticleType)GParticleTypes.WARPED.get(), WarpedProvider::new);
        event.register((ParticleType)GParticleTypes.ALLURITE_RAIN.get(), CrystalRainParticle.Provider::new);
        event.register((ParticleType)GParticleTypes.LUMIERE_RAIN.get(), CrystalRainParticle.Provider::new);
    }
}

