/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.orcinus.galosphere.blocks.PollinatedClusterBlock;
import net.orcinus.galosphere.entities.SparkleEntity;

public class FindClusterGoal
extends Goal {
    private final SparkleEntity sparkle;
    private int eatingTicks = 0;
    private final UniformInt EATING_COOLDOWN = UniformInt.m_146622_((int)400, (int)1200);

    public FindClusterGoal(SparkleEntity sparkle) {
        this.sparkle = sparkle;
    }

    public boolean m_8036_() {
        return this.getClusterPos() != null && !this.sparkle.m_6162_() && this.sparkle.getEatingCooldownTicks() == 0;
    }

    public boolean m_8045_() {
        return this.eatingTicks < 60;
    }

    public void m_8041_() {
        BlockPos pos = this.getClusterPos();
        Level world = this.sparkle.f_19853_;
        if (pos != null) {
            world.m_7731_(pos, (BlockState)world.m_8055_(pos).m_61124_((Property)PollinatedClusterBlock.POLLINATED, (Comparable)Boolean.valueOf(true)), 2);
            world.m_46796_(1500, pos, 1);
            this.sparkle.m_5496_(SoundEvents.f_144242_, 1.0f, 1.0f);
            this.eatingTicks = 0;
            this.sparkle.setEatingCooldownTicks(-this.EATING_COOLDOWN.m_214085_(this.sparkle.m_217043_()));
        }
    }

    public void m_8037_() {
        BlockPos pos = this.getClusterPos();
        if (pos != null) {
            this.sparkle.m_21573_().m_26519_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 1.0);
            this.sparkle.m_21563_().m_24946_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            if (this.eatingTicks % 7 == 0) {
                this.sparkle.m_5496_(SoundEvents.f_11951_, 1.0f, 1.0f);
            }
            if (this.sparkle.m_20183_().m_123314_((Vec3i)pos, 2.0) && this.eatingTicks < 60) {
                ++this.eatingTicks;
            }
        }
    }

    public BlockPos getClusterPos() {
        int radius = 3;
        BlockPos sparklePos = this.sparkle.m_20183_();
        ArrayList list = Lists.newArrayList();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    BlockPos pos = new BlockPos(sparklePos.m_123341_() + x, sparklePos.m_123342_() + y, sparklePos.m_123343_() + z);
                    BlockState blockState = this.sparkle.f_19853_.m_8055_(pos);
                    if (!(blockState.m_60734_() instanceof PollinatedClusterBlock) || ((Boolean)blockState.m_61143_((Property)PollinatedClusterBlock.POLLINATED)).booleanValue()) continue;
                    list.add(pos);
                }
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return (BlockPos)list.get(0);
    }
}

