/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;
import net.orcinus.galosphere.api.BottlePickable;
import net.orcinus.galosphere.api.SpectreBoundSpyglass;
import net.orcinus.galosphere.entities.ai.FlyWanderGoal;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GNetworkHandler;
import net.orcinus.galosphere.init.GParticleTypes;
import net.orcinus.galosphere.init.GSoundEvents;
import net.orcinus.galosphere.network.SendPerspectivePacket;
import org.jetbrains.annotations.Nullable;

public class SpectreEntity
extends PathfinderMob
implements FlyingAnimal,
BottlePickable {
    private static final EntityDataAccessor<Optional<UUID>> MANIPULATOR = SynchedEntityData.m_135353_(SpectreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> CAN_BE_MANIPULATED = SynchedEntityData.m_135353_(SpectreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FROM_BOTTLE = SynchedEntityData.m_135353_(SpectreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public SpectreEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MANIPULATOR, Optional.empty());
        this.f_19804_.m_135372_(CAN_BE_MANIPULATED, (Object)false);
        this.f_19804_.m_135372_(FROM_BOTTLE, (Object)false);
    }

    public void m_7378_(CompoundTag tag) {
        UUID uuid;
        super.m_7378_(tag);
        if (tag.m_128403_("Manipulator")) {
            uuid = tag.m_128342_("Manipulator");
        } else {
            String s = tag.m_128461_("Manipulator");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            this.setManipulatorUUID(uuid);
        }
        this.setFromBottle(tag.m_128471_("FromBottle"));
        this.setCanBeManipulated(tag.m_128471_("CanBeManipulated"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.getManipulatorUUID() != null) {
            tag.m_128362_("Manipulator", this.getManipulatorUUID());
        }
        tag.m_128379_("FromBottle", this.fromBottle());
        tag.m_128379_("CanBeManipulated", this.canBeManipulated());
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)GSoundEvents.SPECTRE_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)GSoundEvents.SPECTRE_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)GSoundEvents.SPECTRE_DEATH.get();
    }

    @Nullable
    public UUID getManipulatorUUID() {
        return ((Optional)this.f_19804_.m_135370_(MANIPULATOR)).orElse(null);
    }

    public void setManipulatorUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(MANIPULATOR, Optional.ofNullable(uuid));
    }

    public boolean canBeManipulated() {
        return (Boolean)this.f_19804_.m_135370_(CAN_BE_MANIPULATED);
    }

    public void setCanBeManipulated(boolean canBeManipulated) {
        this.f_19804_.m_135381_(CAN_BE_MANIPULATED, (Object)canBeManipulated);
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation flyingPathNavigation = new FlyingPathNavigation((Mob)this, level);
        flyingPathNavigation.m_26440_(false);
        flyingPathNavigation.m_7008_(true);
        flyingPathNavigation.m_26443_(true);
        return flyingPathNavigation;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.canBeManipulated() && this.f_19796_.m_188501_() < 0.05f) {
            for (int i = 0; i < this.f_19796_.m_188503_(2) + 1; ++i) {
                this.spawnFluidParticle(this.f_19853_, this.m_20185_() - (double)0.3f, this.m_20185_() + (double)0.3f, this.m_20189_() - (double)0.3f, this.m_20189_() + (double)0.3f, this.m_20227_(0.5), (ParticleOptions)GParticleTypes.ALLURITE_RAIN.get());
            }
        }
    }

    private void spawnFluidParticle(Level world, double minX, double maxX, double minZ, double maxZ, double y, ParticleOptions options) {
        world.m_7106_(options, Mth.m_14139_((double)world.f_46441_.m_188500_(), (double)minX, (double)maxX), y, Mth.m_14139_((double)world.f_46441_.m_188500_(), (double)minZ, (double)maxZ), 0.0, 0.0, 0.0);
    }

    public boolean m_142535_(float f, float g, DamageSource damageSource) {
        return false;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
    }

    protected void m_7840_(double d, boolean bl, BlockState blockState, BlockPos blockPos) {
    }

    protected boolean m_142039_() {
        return this.m_29443_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FlyWanderGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new FloatGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22280_, (double)0.6f).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22277_, 48.0);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.m_5776_() || this.matchesClientPlayerUUID()) {
            Optional optionalUUID = (Optional)this.f_19804_.m_135370_(MANIPULATOR);
            optionalUUID.ifPresent(this::manualControl);
        }
    }

    private void manualControl(UUID uuid) {
        Player player = this.f_19853_.m_46003_(uuid);
        if (player != null) {
            player.f_20900_ = 0.0f;
            player.f_20902_ = 0.0f;
            player.m_6862_(false);
            if (!player.m_150108_() || this.m_21224_()) {
                this.setManipulatorUUID(null);
                if (this.f_19853_.f_46443_) {
                    this.stopUsingSpyglass(player);
                } else {
                    ((SpectreBoundSpyglass)player).setUsingSpectreBoundedSpyglass(false);
                    player.m_6330_((SoundEvent)GSoundEvents.SPECTRE_MANIPULATE_END.get(), this.m_5720_(), 1.0f, 1.0f);
                }
            }
        }
        if (!this.f_19853_.m_5776_() && player == null) {
            this.f_19804_.m_135381_(MANIPULATOR, Optional.empty());
        }
    }

    public boolean m_6785_(double d) {
        return !this.m_8077_() && !this.fromBottle();
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.fromBottle();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void stopUsingSpyglass(Player player) {
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91074_ == player) {
            client.m_91118_((Entity)player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean matchesClientPlayerUUID() {
        return Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_20148_().equals(this.getManipulatorUUID());
    }

    public void m_7023_(Vec3 velocity) {
        if (this.getManipulatorUUID() != null) {
            ((Optional)this.f_19804_.m_135370_(MANIPULATOR)).map(arg_0 -> ((Level)this.f_19853_).m_46003_(arg_0)).ifPresent(this::copyPlayerRotation);
        } else {
            super.m_7023_(velocity);
        }
    }

    private void copyPlayerRotation(Player player) {
        this.m_146922_(player.m_146908_());
        this.f_19859_ = this.m_146908_();
        this.m_146926_(player.m_146909_() * 0.5f);
        this.m_19915_(this.m_146908_(), this.m_146909_());
        this.f_20883_ = this.m_146908_();
        this.f_20885_ = this.m_146908_();
    }

    protected InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack stack = player.m_21120_(interactionHand);
        if (this.canBeManipulated() && (stack.m_150930_((Item)GItems.SPECTRE_BOUND_SPYGLASS.get()) || stack.m_150930_(Items.f_151059_))) {
            this.m_5496_((SoundEvent)GSoundEvents.SPECTRE_LOCK_TO_SPYGLASS.get(), 1.0f, 1.0f);
            ItemStack spectreBoundedSpyglass = new ItemStack((ItemLike)GItems.SPECTRE_BOUND_SPYGLASS.get());
            if (this.m_8077_()) {
                spectreBoundedSpyglass.m_41714_(this.m_7770_());
            }
            SpectreBoundSpyglass.addSpectreBoundedTags(this, spectreBoundedSpyglass.m_41784_());
            player.m_21008_(interactionHand, spectreBoundedSpyglass);
            this.setCanBeManipulated(false);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150930_(Items.f_42590_)) {
            this.f_19853_.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)GSoundEvents.SPECTRE_BOTTLE_FILL.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            if (!this.f_19853_.m_5776_()) {
                this.m_146850_(GameEvent.f_223708_);
                ItemStack itemStack2 = new ItemStack((ItemLike)GItems.BOTTLE_OF_SPECTRE.get());
                BottlePickable.saveDefaultDataFromBottleTag(this, itemStack2);
                player.m_21008_(interactionHand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)itemStack2));
                this.m_146870_();
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150930_((Item)GItems.ALLURITE_SHARD.get()) && this.getManipulatorUUID() == null && !this.canBeManipulated()) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.setCanBeManipulated(true);
            this.m_5496_((SoundEvent)GSoundEvents.SPECTRE_RECEIVE_ITEM.get(), 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, interactionHand);
    }

    public void setCamera(Player player) {
        if (!this.f_19853_.m_5776_()) {
            player.f_20902_ = 0.0f;
            ((SpectreBoundSpyglass)player).setUsingSpectreBoundedSpyglass(true);
            this.setManipulatorUUID(player.m_20148_());
            GNetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new SendPerspectivePacket(player.m_20148_(), this.m_19879_()));
            this.m_5496_((SoundEvent)GSoundEvents.SPECTRE_MANIPULATE_BEGIN.get(), 1.0f, 1.0f);
        }
    }

    public boolean m_29443_() {
        return !this.f_19861_;
    }

    @Override
    public boolean fromBottle() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BOTTLE);
    }

    @Override
    public void setFromBottle(boolean fromBottle) {
        this.f_19804_.m_135381_(FROM_BOTTLE, (Object)fromBottle);
    }
}

