/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.orcinus.galosphere.entities.ai.FindClusterGoal;
import net.orcinus.galosphere.entities.ai.SparkleRandomSwimmingGoal;
import net.orcinus.galosphere.entities.ai.WalkAndSwimGoal;
import net.orcinus.galosphere.entities.ai.WalkToGroundGoal;
import net.orcinus.galosphere.entities.ai.control.SmoothSwimmingGroundControl;
import net.orcinus.galosphere.entities.ai.navigation.SwimWalkPathNavigation;
import net.orcinus.galosphere.init.GBlockTags;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItemTags;
import net.orcinus.galosphere.init.GItems;

public class SparkleEntity
extends Animal {
    public static final EntityDataAccessor<Integer> CRYSTAL_TYPE = SynchedEntityData.m_135353_(SparkleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean groundNavigationInuse;
    private int growthTicks;
    public float prevWaterTicks;
    public float waterTicks;
    private int swimTicks = -1000;
    private int eatingCooldownTicks;
    private static final UniformInt REGROWTH_TICKS = UniformInt.m_146622_((int)6000, (int)12000);
    private static final UniformInt LONG_REGROWTH_TICKS = UniformInt.m_146622_((int)12000, (int)24000);

    public SparkleEntity(EntityType<? extends SparkleEntity> type, Level world) {
        super(type, world);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.switchNavigator(false);
    }

    public float getStepHeight() {
        return 1.0f;
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.f_19853_);
            this.groundNavigationInuse = true;
        } else {
            this.f_21342_ = new SmoothSwimmingGroundControl(this, 1.2f, 1.6f);
            this.f_21344_ = new SwimWalkPathNavigation((Mob)this, this.f_19853_);
            this.groundNavigationInuse = false;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevWaterTicks = this.waterTicks;
        if (this.m_20072_() && this.waterTicks < 5.0f) {
            this.waterTicks += 1.0f;
        }
        if (!this.m_20072_() && this.waterTicks > 0.0f) {
            this.waterTicks -= 1.0f;
        }
        if (this.m_20072_() && this.groundNavigationInuse) {
            this.switchNavigator(false);
        }
        if (!this.m_20072_() && !this.groundNavigationInuse) {
            this.switchNavigator(true);
        }
        if (!this.f_19853_.f_46443_) {
            if (this.eatingCooldownTicks < 0) {
                ++this.eatingCooldownTicks;
            }
            this.swimTicks = this.m_20069_() ? ++this.swimTicks : --this.swimTicks;
        }
    }

    public void m_7023_(Vec3 deltaMovement) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), deltaMovement);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(deltaMovement);
        }
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22277_, 16.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CRYSTAL_TYPE, (Object)0);
    }

    public static boolean checkSparkleSpawnRules(EntityType<? extends LivingEntity> sparkle, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_8055_(pos.m_7495_()).m_204336_(GBlockTags.SPARKLES_SPAWNABLE_ON);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        CrystalType type = this.getRandomType();
        this.setCrystalType(type);
        return super.m_6518_(world, difficulty, spawnReason, data, tag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setCrystalType(CrystalType.BY_ID[tag.m_128451_("CrystalType")]);
        this.setGrowthTicks(tag.m_128451_("GrowthTicks"));
        this.setEatingCooldownTicks(tag.m_128451_("CooldownTicks"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("CrystalType", this.getCrystaltype().getId());
        tag.m_128405_("GrowthTicks", this.getGrowthTicks());
        tag.m_128405_("CooldownTicks", this.getEatingCooldownTicks());
    }

    public void setEatingCooldownTicks(int growthTicks) {
        this.eatingCooldownTicks = growthTicks;
    }

    public int getEatingCooldownTicks() {
        return this.eatingCooldownTicks;
    }

    public void setGrowthTicks(int growthTicks) {
        this.growthTicks = growthTicks;
    }

    public int getGrowthTicks() {
        return this.growthTicks;
    }

    public void setCrystalType(CrystalType type) {
        this.f_19804_.m_135381_(CRYSTAL_TYPE, (Object)type.getId());
    }

    public CrystalType getCrystaltype() {
        return CrystalType.BY_ID[(Integer)this.f_19804_.m_135370_(CRYSTAL_TYPE)];
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new WalkAndSwimGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new WalkToGroundGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_204132_(GItemTags.SPARKLE_TEMPT_ITEMS), false));
        this.f_21345_.m_25352_(6, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(7, (Goal)new FindClusterGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new SparkleRandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(GItemTags.SPARKLE_TEMPT_ITEMS);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob mob) {
        SparkleEntity sparkleEntity = (SparkleEntity)((EntityType)GEntityTypes.SPARKLE.get()).m_20615_((Level)world);
        if (sparkleEntity != null) {
            sparkleEntity.setCrystalType(CrystalType.NONE);
        }
        return sparkleEntity;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.m_5776_()) {
            if (this.getGrowthTicks() > 0) {
                this.setGrowthTicks(this.getGrowthTicks() - 1);
            }
            if (this.getGrowthTicks() == 0 && this.getCrystaltype() == CrystalType.NONE) {
                CrystalType type = this.getRandomType();
                this.setCrystalType(type);
            }
        }
    }

    public CrystalType getRandomType() {
        return this.f_19796_.m_188499_() ? CrystalType.ALLURITE : CrystalType.LUMIERE;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.getCrystaltype() != CrystalType.NONE && stack.m_41720_() instanceof PickaxeItem && !this.m_6162_()) {
            this.extractShard(stack);
            stack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(hand));
            this.m_146852_(GameEvent.f_157781_, (Entity)player);
            return InteractionResult.SUCCESS;
        }
        if (this.getCrystaltype() == CrystalType.NONE && stack.m_204117_(GItemTags.SPARKLE_TEMPT_ITEMS)) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.setGrowthTicks(this.getGrowthTicks() - Mth.m_216271_((RandomSource)this.f_19796_, (int)20, (int)40));
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void extractShard(ItemStack stack) {
        this.spawnShard(stack);
        this.m_5496_(SoundEvents.f_144094_, 1.0f, 1.0f);
        this.setCrystalType(CrystalType.NONE);
        UniformInt growthTicks = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)stack) > 0 ? LONG_REGROWTH_TICKS : REGROWTH_TICKS;
        this.setGrowthTicks(growthTicks.m_214085_(this.m_217043_()));
    }

    private void spawnShard(ItemStack stack) {
        Item item = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)stack) > 0 ? this.getCrystaltype().getSilktouchItem() : this.getCrystaltype().getItem();
        int rolls = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)stack) > 0 ? 1 + EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)stack) : 1;
        for (int i = 0; i < rolls; ++i) {
            this.m_19998_((ItemLike)item);
        }
    }

    public boolean shouldEnterWater() {
        return this.swimTicks <= -1000;
    }

    public boolean shouldLeaveWater() {
        return this.swimTicks > 600;
    }

    public static enum CrystalType {
        NONE(0, "none", null, null),
        ALLURITE(1, "allurite", (Item)GItems.ALLURITE_SHARD.get(), ((Block)GBlocks.ALLURITE_CLUSTER.get()).m_5456_()),
        LUMIERE(2, "lumiere", (Item)GItems.LUMIERE_SHARD.get(), ((Block)GBlocks.LUMIERE_CLUSTER.get()).m_5456_());

        public static final CrystalType[] BY_ID;
        private final int id;
        private final String name;
        private final Item item;
        private final Item silktouchItem;

        private CrystalType(int id, String name, Item item, Item silktouchItem) {
            this.id = id;
            this.name = name;
            this.item = item;
            this.silktouchItem = silktouchItem;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Item getItem() {
            return this.item;
        }

        public Item getSilktouchItem() {
            return this.silktouchItem;
        }

        static {
            BY_ID = (CrystalType[])Arrays.stream(CrystalType.values()).sorted(Comparator.comparingInt(CrystalType::getId)).toArray(CrystalType[]::new);
        }
    }
}

