/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.datagen;

import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.orcinus.galosphere.blocks.CordycepsBlock;
import net.orcinus.galosphere.blocks.PollinatedClusterBlock;
import net.orcinus.galosphere.init.GBlocks;
import org.jetbrains.annotations.NotNull;

public class GBlockstateProvider
extends BlockStateProvider {
    public GBlockstateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "galosphere", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Block)GBlocks.ALLURITE_BLOCK.get());
        this.simpleBlock((Block)GBlocks.LUMIERE_BLOCK.get());
        this.simpleBlock((Block)GBlocks.SMOOTH_AMETHYST.get());
        this.simpleBlock((Block)GBlocks.SMOOTH_ALLURITE.get());
        this.simpleBlock((Block)GBlocks.SMOOTH_LUMIERE.get());
        this.simpleBlock((Block)GBlocks.AMETHYST_BRICKS.get());
        this.simpleBlock((Block)GBlocks.ALLURITE_BRICKS.get());
        this.simpleBlock((Block)GBlocks.LUMIERE_BRICKS.get());
        this.simpleBlock((Block)GBlocks.CHISELED_AMETHYST.get());
        this.simpleBlock((Block)GBlocks.CHISELED_ALLURITE.get());
        this.simpleBlock((Block)GBlocks.CHISELED_LUMIERE.get());
        this.simpleBlock((Block)GBlocks.AMETHYST_LAMP.get());
        this.simpleBlock((Block)GBlocks.ALLURITE_LAMP.get());
        this.simpleBlock((Block)GBlocks.LUMIERE_LAMP.get());
        this.simpleBlock((Block)GBlocks.RAW_SILVER_BLOCK.get());
        this.simpleBlock((Block)GBlocks.SILVER_BLOCK.get());
        this.simpleBlock((Block)GBlocks.SILVER_ORE.get());
        this.simpleBlock((Block)GBlocks.DEEPSLATE_SILVER_ORE.get());
        this.simpleBlock((Block)GBlocks.CHARGED_LUMIERE_BLOCK.get());
        this.simpleBlock((Block)GBlocks.LICHEN_MOSS.get());
        this.crossBlock(GBlocks.LICHEN_ROOTS);
        this.crossBlock(GBlocks.BOWL_LICHEN);
        this.getVariantBuilder((Block)GBlocks.LICHEN_CORDYCEPS.get()).forAllStatesExcept(state -> {
            boolean bulb = (Boolean)state.m_61143_((Property)CordycepsBlock.BULB);
            BlockModelBuilder crossFile = (BlockModelBuilder)((BlockModelBuilder)this.models().cross("lichen_cordyceps", new ResourceLocation("galosphere", "block/lichen_cordyceps"))).renderType("cutout");
            BlockModelBuilder bulbcrossFile = (BlockModelBuilder)((BlockModelBuilder)this.models().cross("lichen_cordyceps_bulb", new ResourceLocation("galosphere", "block/lichen_cordyceps_bulb"))).renderType("cutout");
            return ConfiguredModel.builder().modelFile((ModelFile)(bulb ? bulbcrossFile : crossFile)).build();
        }, new Property[]{CordycepsBlock.f_53924_});
        this.crossBlock(GBlocks.LICHEN_CORDYCEPS_PLANT);
        this.slabBlock((Block)GBlocks.AMETHYST_SLAB.get(), "amethyst_block", true);
        this.slabBlock((Block)GBlocks.ALLURITE_SLAB.get(), "allurite_block");
        this.slabBlock((Block)GBlocks.LUMIERE_SLAB.get(), "lumiere_block");
        this.slabBlock((Block)GBlocks.SMOOTH_AMETHYST_SLAB.get(), "smooth_amethyst");
        this.slabBlock((Block)GBlocks.SMOOTH_ALLURITE_SLAB.get(), "smooth_allurite");
        this.slabBlock((Block)GBlocks.SMOOTH_LUMIERE_SLAB.get(), "smooth_lumiere");
        this.slabBlock((Block)GBlocks.AMETHYST_BRICK_SLAB.get(), "amethyst_bricks");
        this.slabBlock((Block)GBlocks.ALLURITE_BRICK_SLAB.get(), "allurite_bricks");
        this.slabBlock((Block)GBlocks.LUMIERE_BRICK_SLAB.get(), "lumiere_bricks");
        this.stairsBlock((Block)GBlocks.AMETHYST_STAIRS.get(), "amethyst_block", true);
        this.stairsBlock((Block)GBlocks.ALLURITE_STAIRS.get(), "allurite_block");
        this.stairsBlock((Block)GBlocks.LUMIERE_STAIRS.get(), "lumiere_block");
        this.stairsBlock((Block)GBlocks.SMOOTH_AMETHYST_STAIRS.get(), "smooth_amethyst");
        this.stairsBlock((Block)GBlocks.SMOOTH_ALLURITE_STAIRS.get(), "smooth_allurite");
        this.stairsBlock((Block)GBlocks.SMOOTH_LUMIERE_STAIRS.get(), "smooth_lumiere");
        this.stairsBlock((Block)GBlocks.AMETHYST_BRICK_STAIRS.get(), "amethyst_bricks");
        this.stairsBlock((Block)GBlocks.ALLURITE_BRICK_STAIRS.get(), "allurite_bricks");
        this.stairsBlock((Block)GBlocks.LUMIERE_BRICK_STAIRS.get(), "lumiere_bricks");
        this.getVariantBuilder((Block)GBlocks.COMBUSTION_TABLE.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeBottomTop("combustion_table", new ResourceLocation("galosphere", "block/combustion_table_side"), new ResourceLocation("galosphere", "block/combustion_table_bottom"), new ResourceLocation("galosphere", "block/combustion_table_top"))).build());
        this.pollinatedCluster((Block)GBlocks.ALLURITE_CLUSTER.get());
        this.pollinatedCluster((Block)GBlocks.LUMIERE_CLUSTER.get());
    }

    private void pollinatedCluster(@NotNull Block block) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.m_61143_((Property)AmethystClusterBlock.f_152006_);
            int rotationX = 90;
            int rotationY = 90;
            if (facing == Direction.UP) {
                rotationX = 0;
                rotationY = 0;
            } else if (facing == Direction.DOWN) {
                rotationX = 180;
                rotationY = 0;
            } else if (facing == Direction.WEST) {
                rotationY *= 3;
            } else if (facing == Direction.NORTH) {
                rotationY = 0;
            } else if (facing == Direction.SOUTH) {
                rotationY *= 2;
            }
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_(), new ResourceLocation("galosphere", "block/" + ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_()))).renderType("cutout")).rotationX(rotationX).rotationY(rotationY).build();
        }, new Property[]{BlockStateProperties.f_61362_, PollinatedClusterBlock.POLLINATED});
    }

    private void crossBlock(RegistryObject<Block> block) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get()))).m_135815_(), new ResourceLocation("galosphere", "block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_()))).renderType("cutout")).build());
    }

    private void stairsBlock(Block block, String blockMaterial) {
        this.stairsBlock(block, blockMaterial, false);
    }

    private void stairsBlock(Block block, String blockMaterial, boolean flag) {
        String id = flag ? "minecraft" : "galosphere";
        ResourceLocation resourceLocation = new ResourceLocation(id, "block/" + blockMaterial);
        this.stairsBlock((StairBlock)block, resourceLocation);
    }

    private void slabBlock(Block block, String blockMaterial) {
        this.slabBlock(block, blockMaterial, false);
    }

    private void slabBlock(Block block, String blockMaterial, boolean flag) {
        String id = flag ? "minecraft" : "galosphere";
        ResourceLocation resourceLocation = new ResourceLocation(id, "block/" + blockMaterial);
        this.slabBlock((SlabBlock)block, resourceLocation, resourceLocation);
    }
}

