/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.crafting;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.orcinus.galosphere.Galosphere;

public class LumiereReformingManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON_INSTANCE = new GsonBuilder().create();
    private static final Map<Block, Block> REFORMING_TABLE = Maps.newHashMap();

    public LumiereReformingManager() {
        super(GSON_INSTANCE, "loot_tables/gameplay");
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager resourceManagerIn, ProfilerFiller pProfiler) {
        ResourceLocation resourceLocation = new ResourceLocation("galosphere", "loot_tables/gameplay/lumiere_reforming_table.json");
        try {
            for (Resource iResource : resourceManagerIn.m_213829_(resourceLocation)) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(iResource.m_215507_(), StandardCharsets.UTF_8));){
                    JsonObject jsonObject = (JsonObject)GsonHelper.m_13776_((Gson)GSON_INSTANCE, (Reader)reader, JsonObject.class);
                    if (jsonObject == null) continue;
                    JsonArray entryList = jsonObject.get("entries").getAsJsonArray();
                    for (JsonElement entry : entryList) {
                        REFORMING_TABLE.put((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(entry.getAsJsonObject().get("accepted_block").getAsString())), (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(entry.getAsJsonObject().get("returned_block").getAsString())));
                    }
                }
                catch (IOException | RuntimeException exception) {
                    Galosphere.LOGGER.error("Couldn't read lumiere reforming table list {} in data pack {}", (Object)resourceLocation, (Object)iResource.m_215506_(), (Object)exception);
                }
            }
        }
        catch (NoSuchElementException exception) {
            Galosphere.LOGGER.error("Couldn't read lumiere reforming table from {}", (Object)resourceLocation, (Object)exception);
        }
    }

    public static Map<Block, Block> getReformingTable() {
        return REFORMING_TABLE;
    }
}

