/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.orcinus.galosphere.blocks.blockentities.AuraRingerBlockEntity;
import net.orcinus.galosphere.init.GBlockEntityTypes;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GParticleTypes;
import org.jetbrains.annotations.Nullable;

public class AuraRingerBlock
extends BaseEntityBlock {
    public static final BooleanProperty RINGING = BooleanProperty.m_61465_((String)"ringing");

    public AuraRingerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)RINGING, (Comparable)Boolean.valueOf(false)));
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        EntityType dummy = EntityType.f_20501_;
        for (BlockPos blockPos : this.getRadius(pos)) {
            if (!((Boolean)state.m_61143_((Property)RINGING)).booleanValue() || !world.m_46859_(blockPos) || world.m_45517_(LightLayer.BLOCK, blockPos) != 0 || !NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)world, (BlockPos)blockPos, (EntityType)dummy)) continue;
            double posX = (double)blockPos.m_123341_() + 0.5;
            double posY = blockPos.m_123342_();
            double posZ = (double)blockPos.m_123343_() + 0.5;
            world.m_7106_((ParticleOptions)GParticleTypes.AURA_LISTENER.get(), posX, posY + 0.1, posZ, 0.0, 0.0, 0.0);
        }
    }

    public List<BlockPos> getRadius(BlockPos blockPos) {
        int radius = 10;
        int height = 3;
        ArrayList position = Lists.newArrayList();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -height; y <= height; ++y) {
                    BlockPos pos = new BlockPos(blockPos.m_123341_() + x, blockPos.m_123342_() + y, blockPos.m_123343_() + z);
                    if (x * x + z * z > radius * radius) continue;
                    position.add(pos);
                }
            }
        }
        if (position.isEmpty()) {
            return null;
        }
        return position;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> te) {
        return !world.m_5776_() ? AuraRingerBlock.m_152132_(te, (BlockEntityType)((BlockEntityType)GBlockEntityTypes.AURA_RINGER.get()), AuraRingerBlockEntity::ringingTick) : super.m_142354_(world, state, te);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (!((Boolean)state.m_61143_((Property)RINGING)).booleanValue() && stack.m_41720_() == ((Block)GBlocks.ALLURITE_BLOCK.get()).m_5456_()) {
            this.activate(state, world, pos);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            world.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void activate(BlockState state, Level world, BlockPos pos) {
        world.m_186460_(pos, (Block)this, 400);
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)RINGING, (Comparable)Boolean.valueOf(true)), 2);
        world.m_5594_(null, pos, SoundEvents.f_12376_, SoundSource.BLOCKS, 1.0f, 1.5f);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)RINGING)).booleanValue()) {
            world.m_5594_(null, pos, SoundEvents.f_12377_, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)RINGING, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new AuraRingerBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{RINGING});
    }
}

