/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.evilcraft.RegistryEntries;

public class ItemPoisonBottle
extends Item {
    public ItemPoisonBottle(Item.Properties properties) {
        super(properties);
        MinecraftForge.EVENT_BUS.addListener(this::onPoisonRightClick);
    }

    public void onPoisonRightClick(PlayerInteractEvent.RightClickBlock event) {
        InteractionHand hand = event.getEntity().m_7655_();
        if (hand != null && !event.getEntity().m_21120_(hand).m_41619_() && event.getEntity().m_21120_(hand).m_41720_() == Items.f_42590_) {
            BlockHitResult pos = ItemPoisonBottle.m_41435_((Level)event.getLevel(), (Player)event.getEntity(), (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            if (pos != null && pos.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos blockPos = new BlockPos(pos.m_82450_());
                if (event.getLevel().m_7966_(event.getEntity(), blockPos) && event.getEntity().m_36204_(blockPos, event.getFace(), event.getEntity().m_21120_(hand)) && event.getLevel().m_8055_(blockPos).m_60767_() == Material.f_76305_ && event.getLevel().m_6425_(blockPos).m_76152_() == RegistryEntries.FLUID_POISON) {
                    InventoryHelpers.tryReAddToStack((Player)event.getEntity(), (ItemStack)event.getEntity().m_21120_(hand), (ItemStack)new ItemStack((ItemLike)this), (InteractionHand)hand);
                    event.getLevel().m_7471_(blockPos, false);
                    event.setCanceled(true);
                }
            }
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        FluidHandlerItemStackSimple.SwapEmpty capabilityProvider = new FluidHandlerItemStackSimple.SwapEmpty(stack, new ItemStack((ItemLike)Items.f_42590_), 1000);
        capabilityProvider.fill(new FluidStack((Fluid)RegistryEntries.FLUID_POISON, 1000), IFluidHandler.FluidAction.EXECUTE);
        return capabilityProvider;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemColor
    implements net.minecraft.client.color.item.ItemColor {
        public int m_92671_(ItemStack itemStack, int renderPass) {
            return renderPass == 0 ? Helpers.RGBToInt((int)77, (int)117, (int)15) : -1;
        }
    }
}

