/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.cyclops.evilcraft.blockentity.BlockEntityEnvironmentalAccumulator;
import org.cyclops.evilcraft.client.render.blockentity.RenderBlockEntityBeacon;
import org.cyclops.evilcraft.core.recipe.type.RecipeEnvironmentalAccumulator;

public class RenderBlockEntityEnvironmentalAccumulator
extends RenderBlockEntityBeacon<BlockEntityEnvironmentalAccumulator> {
    private static final int ITEM_SPIN_SPEED = 3;

    public RenderBlockEntityEnvironmentalAccumulator(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public void renderBeacon(BlockEntityEnvironmentalAccumulator tile, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (tile.getMovingItemY() != -1.0f) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(-0.5, (double)(-0.5f + tile.getMovingItemY()), -0.5);
            this.renderProcessingItem(matrixStack, bufferIn, tile.getRecipe(), tile.getDegradationWorld(), partialTicks);
            matrixStack.m_85849_();
        }
        super.renderBeacon(tile, partialTicks, matrixStack, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    @Override
    protected boolean isInnerBeam(BlockEntityEnvironmentalAccumulator tile) {
        return tile.getMovingItemY() >= 0.0f;
    }

    private void renderProcessingItem(PoseStack matrixStackIn, MultiBufferSource bufferIn, RecipeEnvironmentalAccumulator recipe, Level world, float partialTickTime) {
        if (recipe == null) {
            return;
        }
        ItemStack stack = recipe.getInputIngredient().m_43908_()[0];
        if (stack.m_41619_()) {
            return;
        }
        double totalTickTime = (float)world.m_46467_() + partialTickTime;
        float angle = (float)(3.0 * (totalTickTime % 360.0));
        if (stack.m_41720_() instanceof BlockItem) {
            matrixStackIn.m_85837_(1.0, (double)0.675f, 1.0);
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(angle));
        } else {
            matrixStackIn.m_85837_(1.0, 1.0, 1.0);
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(angle));
        }
        matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
        Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.FIXED, 0xF000F0, OverlayTexture.f_118083_, matrixStackIn, bufferIn, 0);
    }
}

