/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mcjty.rftoolsutility.modules.teleporter.client.GuiTeleportProbe;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinationClientInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PacketAllReceiversReady {
    private List<TeleportDestinationClientInfo> destinationList;

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.destinationList.size());
        for (TeleportDestination teleportDestination : this.destinationList) {
            teleportDestination.toBytes(buf);
        }
    }

    public PacketAllReceiversReady() {
    }

    public PacketAllReceiversReady(FriendlyByteBuf buf) {
        int size = buf.readInt();
        this.destinationList = new ArrayList<TeleportDestinationClientInfo>(size);
        for (int i = 0; i < size; ++i) {
            this.destinationList.add(new TeleportDestinationClientInfo(buf));
        }
    }

    public PacketAllReceiversReady(List<TeleportDestinationClientInfo> destinationList) {
        this.destinationList = new ArrayList<TeleportDestinationClientInfo>();
        this.destinationList.addAll(destinationList);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> GuiTeleportProbe.setReceivers(this.destinationList));
        ctx.setPacketHandled(true);
    }
}

