/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsutility.modules.logic.items.RedstoneInformationContainer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.tuple.Pair;

public class PacketSendRedstoneData {
    private final Map<Integer, Pair<String, Integer>> channelData;

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.channelData.size());
        for (Map.Entry<Integer, Pair<String, Integer>> entry : this.channelData.entrySet()) {
            buf.writeInt(entry.getKey().intValue());
            buf.m_130070_((String)entry.getValue().getKey());
            buf.writeByte(((Integer)entry.getValue().getRight()).intValue());
        }
    }

    public PacketSendRedstoneData(FriendlyByteBuf buf) {
        this.channelData = new HashMap<Integer, Pair<String, Integer>>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            int channel = buf.readInt();
            String name = buf.m_130136_(Short.MAX_VALUE);
            byte value = buf.readByte();
            this.channelData.put(channel, (Pair<String, Integer>)Pair.of((Object)name, (Object)value));
        }
    }

    public PacketSendRedstoneData(Map<Integer, Pair<String, Integer>> channelData) {
        this.channelData = channelData;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            AbstractContainerMenu container = SafeClientTools.getClientPlayer().f_36096_;
            if (container instanceof RedstoneInformationContainer) {
                ((RedstoneInformationContainer)container).sendData(this.channelData);
            }
        });
        ctx.setPacketHandled(true);
    }
}

