/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.logic.blocks.RedstoneChannelBlock;
import mcjty.rftoolsutility.modules.logic.blocks.RedstoneChannelTileEntity;
import mcjty.rftoolsutility.modules.logic.tools.RedstoneChannels;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;

public class RedstoneReceiverTileEntity
extends RedstoneChannelTileEntity {
    @GuiValue
    private boolean analog = false;
    @Cap(type=CapType.CONTAINER)
    private LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Redstone Receiver").containerSupplier(DefaultContainerProvider.empty(LogicBlockModule.CONTAINER_REDSTONE_RECEIVER, (GenericTileEntity)this)).setupSync((GenericTileEntity)this));

    public RedstoneReceiverTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)LogicBlockModule.TYPE_REDSTONE_RECEIVER.get(), pos, state);
    }

    public static RedstoneChannelBlock createBlock() {
        return new RedstoneChannelBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsutility:logic/redstone_receiver")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"channel", RedstoneChannelBlock::getChannelString)}).tileEntitySupplier(RedstoneReceiverTileEntity::new));
    }

    public boolean getAnalog() {
        return this.analog;
    }

    public void setAnalog(boolean analog) {
        this.analog = analog;
        this.m_6596_();
    }

    public void tickServer() {
        this.support.setRedstoneState((GenericTileEntity)this, this.checkOutput());
    }

    public int checkOutput() {
        RedstoneChannels channels;
        RedstoneChannels.RedstoneChannel ch;
        if (this.channel != -1 && (ch = (channels = RedstoneChannels.getChannels(this.f_58857_)).getChannel(this.channel)) != null) {
            int newout = ch.getValue();
            if (!this.analog && newout > 0) {
                return 15;
            }
            return newout;
        }
        return 0;
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.support.setPowerOutput(tagCompound.m_128451_("rs"));
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        tagCompound.m_128405_("rs", this.support.getPowerOutput());
    }

    @Override
    public void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.analog = info.m_128471_("analog");
    }

    @Override
    public void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        info.m_128379_("analog", this.analog);
    }
}

