/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.crafter.blocks;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.UndoableItemHandler;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.Cached;
import mcjty.lib.varia.InventoryTools;
import mcjty.lib.varia.ItemStackList;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.NamedEnum;
import mcjty.rftoolsbase.api.compat.JEIRecipeAcceptor;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleItem;
import mcjty.rftoolsutility.modules.crafter.CrafterConfiguration;
import mcjty.rftoolsutility.modules.crafter.blocks.CrafterContainer;
import mcjty.rftoolsutility.modules.crafter.data.CraftMode;
import mcjty.rftoolsutility.modules.crafter.data.CraftingRecipe;
import mcjty.rftoolsutility.modules.crafter.data.KeepMode;
import mcjty.rftoolsutility.modules.crafter.data.SpeedMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class CrafterBaseTE
extends TickingTileEntity
implements JEIRecipeAcceptor {
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CrafterContainer.CONTAINER_FACTORY).itemValid(this::isItemValidForSlot).onUpdate((slot, stack) -> this.clearCacheOrUpdateRecipe((Integer)slot)).build();
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)CrafterConfiguration.MAXENERGY.get()).intValue(), (long)((Integer)CrafterConfiguration.RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Crafter").containerSupplier((windowId, player) -> new CrafterContainer((int)windowId, (ContainerFactory)CrafterContainer.CONTAINER_FACTORY.get(), this.m_58899_(), (GenericTileEntity)this, (Player)player)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.INFUSABLE)
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> new DefaultInfusable((BlockEntity)this));
    private final ItemStackList ghostSlots = ItemStackList.create((int)30);
    private final CraftingRecipe[] recipes;
    private final Cached<Predicate<ItemStack>> filterCache = Cached.of(this::createFilterCache);
    @GuiValue
    private SpeedMode speedMode = SpeedMode.SLOW;
    private int selected = -1;
    @GuiValue
    public static final Value<CrafterBaseTE, Integer> SELECTED = Value.create((String)"selected", (Type)Type.INTEGER, CrafterBaseTE::getSelected, CrafterBaseTE::setSelected);
    @GuiValue
    public static final Value<CrafterBaseTE, String> CRAFT_MODE = Value.createEnum((String)"craftMode", (NamedEnum[])CraftMode.values(), CrafterBaseTE::getCraftMode, CrafterBaseTE::setCraftMode);
    @GuiValue
    public static final Value<CrafterBaseTE, String> KEEP_ONE = Value.createEnum((String)"keepOne", (NamedEnum[])KeepMode.values(), CrafterBaseTE::getKeepOne, CrafterBaseTE::setKeepOne);
    public boolean noRecipesWork = false;
    private final CraftingContainer workInventory = new CraftingContainer(new AbstractContainerMenu(null, -1){

        public boolean m_6875_(Player var1) {
            return false;
        }

        public ItemStack m_7648_(Player player, int slot) {
            return ItemStack.f_41583_;
        }
    }, 3, 3);
    @ServerCommand
    public static final Command<?> CMD_REMEMBER = Command.create((String)"crafter.remember", (te, player, params) -> te.rememberItems());
    @ServerCommand
    public static final Command<?> CMD_FORGET = Command.create((String)"crafter.forget", (te, player, params) -> te.forgetItems());
    @ServerCommand
    public static final Command<?> CMD_APPLY = Command.create((String)"crafter.apply", (te, player, params) -> te.applyRecipe());

    private void clearCacheOrUpdateRecipe(Integer slot) {
        this.noRecipesWork = false;
        if (slot == 40) {
            this.filterCache.clear();
        } else if (slot >= 0 && slot < 9) {
            for (int i = 0; i < 9; ++i) {
                this.workInventory.m_6836_(i, this.items.getStackInSlot(i + 0).m_41777_());
            }
            Recipe recipe = CraftingRecipe.findRecipe(this.f_58857_, this.workInventory);
            if (recipe != null) {
                ItemStack result = recipe.m_5874_((Container)this.workInventory);
                this.items.setStackInSlot(9, result);
            } else {
                this.items.setStackInSlot(9, ItemStack.f_41583_);
            }
        }
    }

    public CrafterBaseTE(BlockEntityType type, BlockPos pos, BlockState state, int supportedRecipes) {
        super(type, pos, state);
        this.recipes = new CraftingRecipe[supportedRecipes];
        for (int i = 0; i < this.recipes.length; ++i) {
            this.recipes[i] = new CraftingRecipe();
        }
    }

    public int getSelected() {
        return this.selected;
    }

    private void setSelected(int sel) {
        if (sel == this.selected) {
            return;
        }
        this.selected = sel < 0 || sel >= this.recipes.length ? -1 : sel;
        if (this.selected < 0) {
            for (int i = 0; i < 10; ++i) {
                this.items.setStackInSlot(0 + i, ItemStack.f_41583_);
            }
        } else {
            CraftingRecipe recipe = this.recipes[this.selected];
            this.items.setStackInSlot(9, recipe.getResult());
            CraftingContainer inv = recipe.getInventory();
            int size = inv.m_6643_();
            for (int i = 0; i < size; ++i) {
                this.items.setStackInSlot(0 + i, inv.m_8020_(i));
            }
        }
        this.m_6596_();
    }

    private void applyRecipe() {
        if (this.selected < 0 || this.selected >= this.recipes.length) {
            return;
        }
        CraftingRecipe recipe = this.recipes[this.selected];
        ItemStack[] recipeItems = new ItemStack[9];
        for (int i = 0; i < 9; ++i) {
            recipeItems[i] = this.items.getStackInSlot(i + 0).m_41777_();
        }
        recipe.setRecipe(recipeItems, this.items.getStackInSlot(9).m_41777_());
        this.markDirtyClient();
    }

    private CraftMode getCraftMode() {
        if (this.selected < 0 || this.selected >= this.recipes.length) {
            return CraftMode.EXT;
        }
        return this.recipes[this.selected].getCraftMode();
    }

    private void setCraftMode(CraftMode mode) {
        if (this.selected >= 0 && this.selected < this.recipes.length && this.recipes[this.selected].getCraftMode() != mode) {
            this.recipes[this.selected].setCraftMode(mode);
            this.m_6596_();
        }
    }

    private KeepMode getKeepOne() {
        if (this.selected < 0 || this.selected >= this.recipes.length) {
            return KeepMode.ALL;
        }
        return this.recipes[this.selected].getKeepOne();
    }

    private void setKeepOne(KeepMode keepOne) {
        if (this.selected >= 0 && this.selected < this.recipes.length) {
            if (this.recipes[this.selected].getKeepOne() != keepOne) {
                this.recipes[this.selected].setKeepOne(keepOne);
            }
            this.m_6596_();
        }
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public ItemStackList getGhostSlots() {
        return this.ghostSlots;
    }

    public void setGridContents(List<ItemStack> stacks) {
        this.items.setStackInSlot(9, stacks.get(0));
        for (int i = 1; i < stacks.size(); ++i) {
            this.items.setStackInSlot(0 + i - 1, stacks.get(i));
        }
        this.m_6596_();
    }

    public int getSupportedRecipes() {
        return this.recipes.length;
    }

    public SpeedMode getSpeedMode() {
        return this.speedMode;
    }

    public CraftingRecipe getRecipe(int index) {
        return this.recipes[index];
    }

    public Predicate<ItemStack> createFilterCache() {
        return FilterModuleItem.getCache((ItemStack)this.items.getStackInSlot(40));
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        this.writeGhostBufferToNBT(info);
        this.writeRecipesToNBT(info);
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        CompoundTag info = tagCompound.m_128469_("Info");
        this.readGhostBufferFromNBT(info);
        this.readRecipesFromNBT(info);
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.readGhostBufferFromNBT(info);
        this.readRecipesFromNBT(info);
        this.speedMode = SpeedMode.values()[info.m_128445_("speedMode")];
    }

    private void readGhostBufferFromNBT(CompoundTag tagCompound) {
        ListTag bufferTagList = tagCompound.m_128437_("GItems", 10);
        for (int i = 0; i < bufferTagList.size(); ++i) {
            this.ghostSlots.set(i, (Object)ItemStack.m_41712_((CompoundTag)bufferTagList.m_128728_(i)));
        }
    }

    private void readRecipesFromNBT(CompoundTag tagCompound) {
        ListTag recipeTagList = tagCompound.m_128437_("Recipes", 10);
        for (int i = 0; i < recipeTagList.size(); ++i) {
            this.recipes[i].readFromNBT(recipeTagList.m_128728_(i));
        }
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        this.writeGhostBufferToNBT(info);
        this.writeRecipesToNBT(info);
        info.m_128344_("speedMode", (byte)this.speedMode.ordinal());
    }

    private void writeGhostBufferToNBT(CompoundTag tagCompound) {
        ListTag bufferTagList = new ListTag();
        for (ItemStack stack : this.ghostSlots) {
            CompoundTag CompoundNBT = new CompoundTag();
            if (!stack.m_41619_()) {
                stack.m_41739_(CompoundNBT);
            }
            bufferTagList.add((Object)CompoundNBT);
        }
        tagCompound.m_128365_("GItems", (Tag)bufferTagList);
    }

    private void writeRecipesToNBT(CompoundTag tagCompound) {
        ListTag recipeTagList = new ListTag();
        for (CraftingRecipe recipe : this.recipes) {
            CompoundTag CompoundNBT = new CompoundTag();
            recipe.writeToNBT(CompoundNBT);
            recipeTagList.add((Object)CompoundNBT);
        }
        tagCompound.m_128365_("Recipes", (Tag)recipeTagList);
    }

    protected void tickServer() {
        int i;
        int steps;
        if (!this.isMachineEnabled() || this.noRecipesWork) {
            return;
        }
        int defaultCost = (Integer)CrafterConfiguration.rfPerOperation.get();
        int rf = this.infusableHandler.map(inf -> (int)((float)defaultCost * (2.0f - inf.getInfusedFactor()) / 2.0f)).orElse(defaultCost);
        int n = steps = this.speedMode == SpeedMode.FAST ? (Integer)CrafterConfiguration.speedOperations.get() : 1;
        if (rf > 0) {
            steps = (int)Math.min((long)steps, this.energyStorage.getEnergy() / (long)rf);
        }
        for (i = 0; i < steps; ++i) {
            if (this.craftOneCycle()) continue;
            this.noRecipesWork = true;
            break;
        }
        if ((rf *= i) > 0) {
            this.energyStorage.consumeEnergy((long)rf);
        }
    }

    private boolean craftOneCycle() {
        boolean craftedAtLeastOneThing = false;
        for (CraftingRecipe craftingRecipe : this.recipes) {
            if (!this.craftOneItem(craftingRecipe)) continue;
            craftedAtLeastOneThing = true;
        }
        return craftedAtLeastOneThing;
    }

    private boolean craftOneItem(CraftingRecipe craftingRecipe) {
        Recipe recipe = craftingRecipe.getCachedRecipe(this.f_58857_);
        if (recipe == null) {
            return false;
        }
        UndoableItemHandler undoHandler = new UndoableItemHandler((IItemHandlerModifiable)this.items);
        if (!this.testAndConsume(craftingRecipe, undoHandler)) {
            undoHandler.restore();
            return false;
        }
        ItemStack result = ItemStack.f_41583_;
        try {
            result = recipe.m_5874_((Container)this.workInventory);
        }
        catch (RuntimeException e) {
            Logging.logError((String)"Problem with recipe!", (Throwable)e);
        }
        CraftMode mode = craftingRecipe.getCraftMode();
        if (!result.m_41619_() && this.placeResult(mode, (IItemHandlerModifiable)undoHandler, result)) {
            NonNullList remaining = recipe.m_7457_((Container)this.workInventory);
            CraftMode remainingMode = mode == CraftMode.EXTC ? CraftMode.INT : mode;
            for (ItemStack s : remaining) {
                if (s.m_41619_() || this.placeResult(remainingMode, (IItemHandlerModifiable)undoHandler, s)) continue;
                undoHandler.restore();
                return false;
            }
            return true;
        }
        undoHandler.restore();
        return false;
    }

    private boolean testAndConsume(CraftingRecipe craftingRecipe, UndoableItemHandler undoHandler) {
        int keep = craftingRecipe.getKeepOne() == KeepMode.KEEP ? 1 : 0;
        for (int i = 0; i < this.workInventory.m_6643_(); ++i) {
            this.workInventory.m_6836_(i, ItemStack.f_41583_);
        }
        Recipe recipe = craftingRecipe.getCachedRecipe(this.f_58857_);
        int w = 3;
        int h = 3;
        if (recipe instanceof ShapedRecipe) {
            w = ((ShapedRecipe)recipe).getRecipeWidth();
            h = ((ShapedRecipe)recipe).getRecipeHeight();
        }
        NonNullList ingredients = recipe.m_7527_();
        for (int x = 0; x < w; ++x) {
            block2: for (int y = 0; y < h; ++y) {
                Ingredient ingredient;
                int index = y * w + x;
                if (index >= ingredients.size() || (ingredient = (Ingredient)ingredients.get(index)) == Ingredient.f_43901_) continue;
                for (int j = 0; j < 26; ++j) {
                    int slotIdx = 10 + j;
                    ItemStack input = undoHandler.getStackInSlot(slotIdx);
                    if (input.m_41619_() || input.m_41613_() <= keep || !ingredient.test(input)) continue;
                    undoHandler.remember(slotIdx);
                    ItemStack copy = input.m_41620_(1);
                    this.workInventory.m_6836_(y * 3 + x, copy);
                    continue block2;
                }
            }
        }
        return recipe.m_5818_((Container)this.workInventory, this.f_58857_);
    }

    private boolean placeResult(CraftMode mode, IItemHandlerModifiable undoHandler, ItemStack result) {
        int stop;
        int start;
        if (mode == CraftMode.INT) {
            start = 10;
            stop = 36;
        } else {
            start = 36;
            stop = 40;
        }
        ItemStack remaining = InventoryTools.insertItemRanged((IItemHandler)undoHandler, (ItemStack)result, (int)start, (int)stop, (boolean)true);
        if (remaining.m_41619_()) {
            InventoryTools.insertItemRanged((IItemHandler)undoHandler, (ItemStack)result, (int)start, (int)stop, (boolean)false);
            return true;
        }
        return false;
    }

    private void rememberItems() {
        for (int i = 0; i < this.ghostSlots.size(); ++i) {
            int slotIdx = i < 26 ? i + 10 : i + 36 - 26;
            if (this.items.getStackInSlot(slotIdx).m_41619_()) continue;
            ItemStack stack = this.items.getStackInSlot(slotIdx).m_41777_();
            stack.m_41764_(1);
            this.ghostSlots.set(i, (Object)stack);
        }
        this.noRecipesWork = false;
        this.markDirtyClient();
    }

    private void forgetItems() {
        for (int i = 0; i < this.ghostSlots.size(); ++i) {
            this.ghostSlots.set(i, (Object)ItemStack.f_41583_);
        }
        this.noRecipesWork = false;
        this.markDirtyClient();
    }

    public boolean isItemValidForSlot(int slot, @Nonnull ItemStack stack) {
        if (slot >= 0 && slot <= 9) {
            return false;
        }
        if (slot >= 10 && slot < 36) {
            ItemStack ghostSlot = (ItemStack)this.ghostSlots.get(slot - 10);
            if (!ghostSlot.m_41619_() && !ghostSlot.m_41656_(stack)) {
                return false;
            }
            ItemStack filterModule = this.items.getStackInSlot(40);
            if (!filterModule.m_41619_() && this.filterCache.get() != null) {
                return ((Predicate)this.filterCache.get()).test(stack);
            }
        } else if (slot >= 36 && slot < 40) {
            ItemStack ghostSlot = (ItemStack)this.ghostSlots.get(slot - 36 + 26);
            if (!ghostSlot.m_41619_() && !ghostSlot.m_41656_(stack)) {
                return false;
            }
        } else if (slot == 40) {
            return stack.m_41720_() instanceof FilterModuleItem;
        }
        return true;
    }
}

