/*
 * Decompiled with CFR 0.152.
 */
package cofh.capable_cauldrons.util;

import cofh.capable_cauldrons.block.entity.CauldronBlockEntity;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public class CauldronUtils {
    protected static BiMap<Fluid, BlockState> CAULDRON_MAP = HashBiMap.create();

    private CauldronUtils() {
    }

    public static void setup() {
        CauldronUtils.addMapping((Fluid)Fluids.f_76193_, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)));
        CauldronUtils.addMapping((Fluid)Fluids.f_76195_, Blocks.f_152477_.m_49966_());
    }

    public static void addMapping(Fluid fluid, BlockState state) {
        CAULDRON_MAP.put((Object)fluid, (Object)state);
    }

    public static BlockState getCauldronForFluid(FluidStack fluid) {
        return (BlockState)CAULDRON_MAP.get((Object)fluid.getFluid());
    }

    public static BlockState getCauldronForFluid(Fluid fluid) {
        return (BlockState)CAULDRON_MAP.get((Object)fluid);
    }

    public static Fluid getFluidForCauldron(BlockState state) {
        return (Fluid)CAULDRON_MAP.inverse().get((Object)state);
    }

    public static DispenseItemBehavior dispenseBucket(BucketItem bucket, DispenseItemBehavior defaultReturn) {
        if (bucket == Items.f_42446_) {
            return CauldronUtils.fillBucket(defaultReturn);
        }
        return CauldronUtils.emptyBucket(bucket.getFluid(), defaultReturn);
    }

    public static DispenseItemBehavior fillBucket(DispenseItemBehavior defaultReturn) {
        return (source, item) -> {
            CauldronBlockEntity blockEntity;
            Fluid fluid;
            BlockPos pos;
            ServerLevel level = source.m_7727_();
            BlockEntity patt2383$temp = level.m_7702_(pos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)));
            if (patt2383$temp instanceof CauldronBlockEntity && (fluid = CauldronUtils.getFluidForCauldron((blockEntity = (CauldronBlockEntity)patt2383$temp).m_58900_())) != null) {
                blockEntity.replaceBlockAndUpdate(Blocks.f_50256_.m_49966_());
                level.m_46796_(1000, source.m_7961_(), 0);
                return new ItemStack((ItemLike)fluid.m_6859_());
            }
            return defaultReturn.m_6115_(source, item);
        };
    }

    public static DispenseItemBehavior emptyBucket(Fluid fluid, DispenseItemBehavior defaultReturn) {
        return (source, item) -> {
            BlockPos pos;
            ServerLevel level = source.m_7727_();
            BlockEntity patt3237$temp = level.m_7702_(pos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)));
            if (patt3237$temp instanceof CauldronBlockEntity) {
                CauldronBlockEntity blockEntity = (CauldronBlockEntity)patt3237$temp;
                BlockState state = CauldronUtils.getCauldronForFluid(fluid);
                if (state != null) {
                    blockEntity.replaceBlockAndUpdate(state);
                    level.m_46796_(1000, source.m_7961_(), 0);
                    return new ItemStack((ItemLike)Items.f_42446_);
                }
            }
            return defaultReturn.m_6115_(source, item);
        };
    }
}

