/*
 * Decompiled with CFR 0.152.
 */
package cofh.capable_cauldrons.capabilities;

import cofh.capable_cauldrons.block.entity.CauldronBlockEntity;
import cofh.capable_cauldrons.util.CauldronUtils;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class CauldronTank
implements IFluidHandler {
    protected final CauldronBlockEntity blockEntity;

    public CauldronTank(CauldronBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        if (this.blockEntity.m_58901_()) {
            return FluidStack.EMPTY;
        }
        Fluid fluid = CauldronUtils.getFluidForCauldron(this.blockEntity.m_58900_());
        if (fluid != null) {
            return new FluidStack(fluid, this.getTankCapacity(0));
        }
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return 1000;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return CauldronUtils.getCauldronForFluid(stack) != null;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.blockEntity.m_58901_() || resource.isEmpty() || !this.isFluidValid(0, resource)) {
            return 0;
        }
        FluidStack fluid = this.getFluidInTank(0);
        if (fluid.isEmpty() || !fluid.isFluidEqual(resource)) {
            int capacity = this.getTankCapacity(0);
            if (resource.getAmount() >= capacity) {
                if (action.execute()) {
                    this.blockEntity.replaceBlockAndUpdate(CauldronUtils.getCauldronForFluid(resource));
                }
                return capacity;
            }
        }
        return 0;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.blockEntity.m_58901_() || resource.isEmpty() || !this.getFluidInTank(0).isFluidEqual(resource)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.blockEntity.m_58901_()) {
            return FluidStack.EMPTY;
        }
        FluidStack fluid = this.getFluidInTank(0);
        if (maxDrain >= fluid.getAmount()) {
            if (action.execute()) {
                this.blockEntity.replaceBlockAndUpdate(Blocks.f_50256_.m_49966_());
            }
            return fluid.copy();
        }
        return FluidStack.EMPTY;
    }
}

